(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     87194,       2434]*)
(*NotebookOutlinePosition[     88012,       2464]*)
(*  CellTagsIndexPosition[     87938,       2458]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Transformada de Fourier Discreta", "Title"],

Cell["\<\
Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Introducci\[OAcute]n te\[OAcute]rica", "Section"]], \
"Section"],

Cell[TextData[{
  "La Transformada de Fourier Discreta (DFT) de un vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \((Y\_0, 
              Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)}]}], TraditionalForm]]],
  " (ambos vectores se consideran en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  ") cuyas componentes vienen dadas por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(Y\_n = \(1\/N\) \(\[Sum]\+\(k = 0\)\%\(N - \
1\)\(\(y\_k\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ n\ k/
                              N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 0, 1, 
                        2,  ... , N - 1)\)\(\ \)\)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                    ", \((1)\)}]], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Los  ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " son llamados los ",
  StyleBox["coeficientes espectrales",
    FontSlant->"Italic"],
  " de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ". Como las igualdades (1) tienen perfecto sentido para cualquier entero ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(n + N\) = Y\_n\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \((Y\_0, 
              Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)}]}], TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el espacio de la frecuencia y \
peri\[OAcute]dica con per\[IAcute]odo ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(k + N\) = Y\_k\)],
    FontWeight->"Bold"],
  StyleBox[" para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`k \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ".  "
}], "Text"],

Cell["A su vez la se\[NTilde]al original se puede expresar en la forma", \
"Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(y\_n = \[Sum]\+\(k = 0\)\%\(N - 1\)\(\(Y\_k\) \(\
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/
                            N\)\)\(\
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 0, 1, 2,  ... , 
                      N - 1)\)\(\ \)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                     ", \((2)\)}]], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (2) tienen perfecto sentido para cualquier entero ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(n + N\) = y\_n\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el tiempo y peri\[OAcute]dica \
con per\[IAcute]odo ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`y\_\(q + N\) = y\_q\)],
    FontWeight->"Bold"],
  StyleBox[" para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`q \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Es f\[AAcute]cil definir un comando que calcule simb\[OAcute]licamente \
dicha transformada. Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`N\ Y\_\(\(n\)\(\ \)\)\)]],
  "se obtiene haciendo el producto escalar en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  "del vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " por el vector "
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Omega]",
                FontWeight->"Bold"], "n"], "=", 
            
            RowBox[{\((1, \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n/N\), \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ 2/N\),  ... , \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ \((N - 1)\)/N\))\), "=", 
              
              RowBox[{\((1, \[Omega]\^n, \[Omega]\^\(2\ n\),  ... , \
\[Omega]\^\(\((N - 1)\) n\))\), "    ", 
                
                FormBox[\(\((0 \[LessEqual] \ n\  \[LessEqual] \ 
                      N - 1)\)\(\ \)\),
                  "TraditionalForm"], "donde", 
                
                FormBox[\(\[Omega] = \[ExponentialE]\^\(2  \[ImaginaryI]\ \
\[Pi]/N\)\),
                  "TraditionalForm"]}]}]}], ",", \(esto\ \(\(es\)\(:\)\)\)}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          FormBox[
            RowBox[{\(Y\_n\), "=", 
              RowBox[{\(1\/N\), 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["y",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Plain"], 
                    SubscriptBox[
                      StyleBox["\[Omega]",
                        FontWeight->"Bold"], "n"]}], ")"}]}]}],
            "TraditionalForm"], "                   ", 
          
          FormBox[\(\((n = 0, 1, 2,  ... , 
              N - 1)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\),
            "TraditionalForm"], \((2  b)\)}]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El ",
  StyleBox["espectro",
    FontWeight->"Bold"],
  " de la se\[NTilde]al ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". El ",
  StyleBox["espectro de amplitudes",
    FontWeight->"Bold"],
  " es el conjunto  ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Abs[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " y el ",
  StyleBox["espectro de fases",
    FontWeight->"Bold"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Arg[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". Dichos conjuntos suelen representarse por segmentos de l\[IAcute]nea que \
unen los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((n/N, 0)\)\)]],
  " con los puntos del espectro correspondiente. Debido a la periodicidad de \
los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " es suficiente representar dichos espectros para ",
  StyleBox["N ",
    FontSlant->"Italic"],
  "valores consecutivos de ",
  StyleBox["n",
    FontSlant->"Italic"],
  ". ",
  StyleBox["En todo lo que sigue hay que considerar que N  es un \
n\[UAcute]mero par",
    FontSlant->"Italic"],
  ".\nEs importante no olvidar que ",
  StyleBox["la segunda mitad de la DFT",
    FontWeight->"Bold"],
  ", es decir, los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`N/2 + 1 \[LessEqual] k \[LessEqual] N - 1\)]],
  ", ",
  StyleBox["corresponde a frecuencias negativas",
    FontWeight->"Bold"],
  " que se combinan con las positivas para reconstruir la se\[NTilde]al \
original. En otras palabras, estos coeficientes no aportan frecuencias \
nuevas. Esto es f\[AAcute]cil de comprobar a partir de las igualdades (2) \
teniendo en cuenta la periodicidad de los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)]],
  " y de la exponencial compleja."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            
            FormBox[\(y\_n = \(\(\[Sum]\+\(k = 0\)\%\(N - 1\)\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/N\)\)\(=\)\)\),
              
              "TraditionalForm"], \(\[Sum]\+\(k = 0\)\%\(N/2\)\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/N\)\)}], 
          "+", \(\[Sum]\+\(k = N/2 + 1\)\%\(N - 1\)\(Y\_\(k - 
                    N\)\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ \((k \
- N)\)/N\)\)}], "=", 
        " ", \(\(\[Sum]\+\(k = 0\)\%\(N/2\)\(Y\_k\) \[ExponentialE]\^\(2\ \
\[ImaginaryI]\ \[Pi]\ n\ k/N\) + \[Sum]\+\(k = \(-N\)/2 + 1\)\%\(-1\)\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/N\)\)\(=\)\)}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      RowBox[{"=", 
        RowBox[{\(Y\_0\), "+", \(\(\((\(-1\))\)\^n\) Y\_\(N/2\)\), "+", 
          
          FormBox[\(\[Sum]\+\(k = 1\)\%\(N/2 - \
1\)\((\[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\
\ n\ k/N\) + \(Y\_\(-k\)\) \[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ n\ \
k/N\)\[NegativeThinSpace])\)\),
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Recuerda tambi\[EAcute]n que el polinomio trigonom\[EAcute]trico de \
periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " y cuya frecuencia m\[AAcute]xima es ",
  Cell[BoxData[
      \(TraditionalForm\`N/2  T\)]]
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[\(\(\ \)\(P(
            t) = \ \(\[Sum]\+\(k = \(-N\)/2\)\%\(N/2 - 1\)Y\_k\ \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\)\  = 
            Y\_0 + \(Y\_\(N/
                      2\)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ \
t\ N\ /2  T\) + \[Sum]\+\(k = 1\)\%\(N/2 - 1\)\((\[NegativeThinSpace]\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\) + \(Y\_\(-k\)\) \
\[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ t\ k/T\)\[NegativeThinSpace])\
\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((3)\)\)\)\)], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`P(n\ T/N) = 
        y\_n\ \ \ \ \ \ \((n = 0, 1, 2,  ... , N - 1)\)\)]],
  ". Dicho polinomio est\[AAcute] determinado de manera \[UAcute]nica por la \
DFT."
}], "Text"],

Cell[TextData[{
  "Para se\[NTilde]ales reales, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(y\_k\),
            "TraditionalForm"], "\[Element]", "\[DoubleStruckCapitalR]"}], 
        TraditionalForm]]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\&__\_n\)]],
  " donde la barra indica complejo conjugado. Lo que se expresa diciendo que \
",
  StyleBox["la DFT de una se\[NTilde]al real es hemisim\[EAcute]trica",
    FontWeight->"Bold"],
  ". Como ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_\(N - n\)\)]],
  ", haciendo ",
  Cell[BoxData[
      \(TraditionalForm\`n = N/2 - k\)]],
  " obtenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\&__\_\(N/2 - k\)\)]],
  " y por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(Y\_\(N/2 + 
                k\)\)\(|\)\) = \(\(\(|\)\(Y\&__\_\(N/2 - 
                  k\)\)\(|\)\) = \(\(|\)\(Y\_\(N/2 - k\)\)\(|\)\)\)\)]],
  ", esto es ",
  StyleBox["el espectro de amplitudes es sim\[EAcute]trico respecto a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold"],
  ". Tambi\[EAcute]n deducimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Arg", "(", 
            FormBox[\(Y\_\(N/2 + k\)\),
              "TraditionalForm"], ")"}], 
          FormBox[
            RowBox[{"=", 
              RowBox[{"Arg", 
                FormBox[
                  RowBox[{\((Y\&__\_\(N/2 - k\))\), "=", 
                    RowBox[{"-", 
                      RowBox[{"Arg", "(", 
                        FormBox[\(Y\_\(N/2 - k\)\),
                          "TraditionalForm"], ")"}]}]}],
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  ", es decir, ",
  StyleBox["el espectro de fases es antisim\[EAcute]trico respecto a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold"],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_0\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2\)\)]],
  " han de ser reales."
}], "Text"],

Cell[TextData[{
  "Para se\[NTilde]ales reales podemos escribir el polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`P(t)\)]],
  " dado por (3) en la forma siguiente. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k = a\_k + i\ b\_k\ , 
      1 \[LessEqual] k \[LessEqual] N/2 - 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(P(t)\), "=", 
        RowBox[{\(Y\_0\), "+", 
          RowBox[{
            
            FormBox[\(\(\(Y\_\(N/
                          2\)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \
\[Pi]\ t\ N\ /2  T\) + \[Sum]\+\(k = 1\)\%\(N/2 - 1\)2  
                      Re\ \((\ \[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\
\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\)\[NegativeThinSpace])\)\)\(\ \)\(=\)\),
              "TraditionalForm"], \(Y\_0\)}], "+", 
          
          FormBox[\(\(Y\_\(N/
                      2\)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ \
t\ N\ /2  T\) + \[Sum]\+\(k = 1\)\%\(N/2 - \
1\)2\ \[NegativeThinSpace]\((\(a\_k\) \(cos(
                          2\ \[Pi]\ t\ k/
                              T\[NegativeThinSpace])\) - \(b\_k\) \(sen(
                          2\ \[Pi]\ t\ k/T\[NegativeThinSpace])\))\)\),
            "TraditionalForm"]}]}], TraditionalForm]], "Text"],

Cell[TextData[{
  "Para que este polinomio pueda escribirse en la forma siguiente (donde para \
",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] N/2 - 1\)]],
  " los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A\_k\)\(\[GreaterEqual]\)\(0\)\(\ \)\)\)]],
  " son las ",
  StyleBox["amplitudes",
    FontWeight->"Bold"],
  " y los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Phi]\_k\)\(\[Element]\)\)\)]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "] son las ",
  StyleBox["fases",
    FontWeight->"Bold"],
  ")"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{\(P(t)\), "=", 
                RowBox[{\(A\_0\), "+", 
                  FormBox[\(\[Sum]\+\(k = 1\)\%\(N/2 - 1\)\),
                    "TraditionalForm"]}]}],
              "TraditionalForm"], \(A\_k\), \(cos(
              2  k\ \[Pi]\ t/T + \[Phi]\_k)\)}], 
          "=", \(A\_0 + \[Sum]\+\(k = 1\)\%\(N/2 - 1\)\((A\_k\ \
\(cos(\[Phi]\_k)\) \(cos(
                        2  k\ \[Pi]\ t/
                            T)\) - \(A\_k\) \(sen(\[Phi]\_k)\) \(sen(
                        2\ k\ \[Pi]\ t/T)\))\)\ \ \ \ \ \ \ \ \((4)\)\)}]], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es condici\[OAcute]n necesaria y suficiente que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2\) = 0\)]],
  ", en cuyo caso se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`A\_0 = Y\_0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`2  Y\_k = \(A\_k\)(
          cos(\[Phi]\_k) + i\ \(sen(\[Phi]\_k)\))\)]],
  " por lo que deducimos que ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k = 2 | Y\_k | \)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_k = arg(Y\_k)\)]],
  "."
}], "Text"],

Cell[TextData[{
  " Si, adem\[AAcute]s, la se\[NTilde]al ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es ",
  StyleBox["par",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`y\_k = \(y\_\(-k\) = y\_\(N - k\)\)\)]],
  ", equivalentemente ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)],
    FontWeight->"Bold"],
  ", entonces se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_n\)]],
  " y la DFT tambi\[EAcute]n es par y real pues ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n = Y\&__\_n\)]],
  " e",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\_\(N/2 - k\)\)],
    FontWeight->"Bold"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones simb\[OAcute]licas con la DFT", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Define un comando que proporcione simb\[OAcute]licamente los vectores \
\[Omega][n,N]  (",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  ").\nb) Comprueba para ",
  Cell[BoxData[
      \(TraditionalForm\`N = 6\)]],
  " que los vectores antes definidos forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^6\)]],
  ". Usa el comando Simplify[ ] si es preciso.\nc) Define un comando \
DFT[lista] que proporcione la transformada de Fourier discreta de \"lista\". \
Usa para ello los vectores \[Omega][n,N] y el producto escalar. Conviene que \
al definir este comando uses tambi\[EAcute]n los comandos Simplify[ ] y Chop[ \
]. Este comando debe trabajar simb\[OAcute]licamente.\nObservaci\[OAcute]n: \
Claro est\[AAcute] que este comando no es \[UAcute]til para hacer \
c\[AAcute]lculos largos, pero tiene la ventaja de que puede trabajar simb\
\[OAcute]licamente lo que nos permite entender bien lo que hace. \nd) Define \
un comando, revertida[lista_], que al aplicarlo a una lista de elementos deje \
igual el primero e invierta el orden de los dem\[AAcute]s.\ne) Define un \
comando \"inversaDFT[lista]\" que calcule la inversa de la transformada de \
Fourier discreta usando el comando DFT[ ] que has definido en el apartado c) \
y el comando definido en el apartado anterior. Comprueba dicho comando con \
algunos ejemplos. \nSugerencia. Aplica dos veces DFT[ ] a una muestra simb\
\[OAcute]lica de unos pocos elementos. \nf) Decimos que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es par si es sim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  " (suponemos que ",
  StyleBox["N",
    FontSlant->"Italic"],
  " es par), es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". Decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es impar si es antisim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = \(-y\_\(N/2 + k\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". \nDefine comandos \"par[se\[NTilde]al]\"  (\"impar[se\[NTilde]al]\") que \
transformen una se\[NTilde]al (finita) dada en otra se\[NTilde]al par (impar) \
de forma que se verifique la igualdad se\[NTilde]al = par[se\[NTilde]al] + \
impar[se\[NTilde]al]; adem\[AAcute]s, si la se\[NTilde]al es par debe \
verificarse que  se\[NTilde]al = par[se\[NTilde]al].\nSugerencia: Usa el \
comando revertida[lista] definido en d).\ng) Genera una lista de 32 \
n\[UAcute]meros aleatorios a= rlist[32]. Calcula DFT[par[a]] y comprueba que \
todos sus elementos son reales y es par. Calcula DFT[impar[a]] y comprueba \
que todos sus elementos son imaginarios puros (considerando 0 como imaginario \
puro) y es impar. Comprueba que DFT[a] = DFT[par[a]] + DFT[impar[a]].\nh) \
Comprueba, usando c\[AAcute]lculo simb\[OAcute]lico con una lista de unos \
pocos elementos (no m\[AAcute]s de 8), que la DFT de una se\[NTilde]al par \
(impar) es una se\[NTilde]al par (impar).\ni) Comprueba, usando \
c\[AAcute]culo simb\[OAcute]lico con una lista de unos pocos elementos (no m\
\[AAcute]s de 8), que la DFT de una se\[NTilde]al real es \
hemisim\[EAcute]trica respecto a ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\&__\_\(N/2 - k\)\)]],
  ".\nj) Indica la relaci\[OAcute]n que hay entre la DFT de una muestra \
{a,b,c,d} y las DFT de las siguientes muestras:\nj1) {a,b,c,d,a,b,c,d} \
(duplicar una muestra)\nj2) {a,b,c,d,a,b,c,d,a,b,c,d} (triplicar una muestra)\
\nj3) {a,0,b,0,c,0,d,0} (alternar con ceros)\nj4) {a,b,c,d,0,0,0,0} (\"zero \
padding\")"
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparaci\[OAcute]n de espectros", "Section"],

Cell[TextData[{
  "Recuerda que el espectro de una se\[NTilde]al peri\[OAcute]dica cuya serie \
de Fourier compleja es ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto de puntos ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". An\[AAcute]logamente, el espectro de una se\[NTilde]al peri\[OAcute]dica \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". \nPodemos comparar los coeficientes de Fourier ",
  Cell[BoxData[
      \(TraditionalForm\`c\_n\)]],
  " con su aproximaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  ". Por la forma en que se calcularon los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " esperamos que se tenga ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(c\_n \[TildeEqual] Y\_n\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-N\)/2 \[LessEqual] n \[LessEqual] N/2 - 1\)]],
  ". En el siguiente ejercicio te pido que compruebes esto."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Considera la extensi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(2  \[Pi]\)\(-\)\)\)]],
  "peri\[OAcute]dica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[t] = t\ Sin[t]\)]],
  "  (",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  "). Pide a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que construya una tabla de tres columnas con encabezados \"n\", \"c[n]\", \
\"Y[n,N]\"; donde c[n] son los coeficientes de Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "; Y[n,N] son los valores de la transformada de Fourier discreta de una \
muestra de la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos igualmente espaciados del intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ". Se trata de comparar los c[n] con los Y[n,N] para valores ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] 14\)]],
  ". Haz dos tablas correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 30\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 100\)]],
  ". \nSugerencia. Puedes definir un comando que dependa de un \
par\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " y que d\[EAcute] como salida la tabla que se pide. Deber\[AAcute]s usar \
el comando TableForm[ ]. Procura hacer los c\[AAcute]lculos de forma num\
\[EAcute]rica y \"de una vez\"."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "DFT en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"Fourier[lista]\" para calcular la DFT que usa el \
algoritmo de la Transformada R\[AAcute]pida de Fourier. Pero ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " define la DFT en la forma siguiente"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\t", 
        FormBox[\(Y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                      y\_k\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ \
\((n - 1)\) \((\ k - 1)\)/N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 
                    2,  ... , N)\)\(\ \)\)\)\),
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es decir, divide por ",
  Cell[BoxData[
      \(TraditionalForm\`\@N\)]],
  "en vez de por ",
  StyleBox["N",
    FontSlant->"Italic"],
  " y conjuga las exponenciales. A su vez, el comando \"InverseFourier[lista]\
\" calcula la transformada inversa de Fourier que en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " est\[AAcute] definida por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\t", 
        FormBox[\(y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                      Y\_k\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \
\[Pi]\ \((n - 1)\) \((\ k - 1)\)/N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 
                    2,  ... , N)\)\(\ \)\)\)\),
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir, nuestro comando DFT[lista] es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`InverseFourier[lista]/\@Length[lista]\)]],
  " . Realmente, no es preciso invocar a la transformada inversa para \
calcular nuestra DFT pues basta con ajustar unos par\[AAcute]metros (consulta \
",
  ButtonBox["Fourier",
    ButtonStyle->"MainBookLink"],
  " en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") de la forma que sigue."
}], "Text"],

Cell[BoxData[{
    \(\(a = Table[Random[], {12}];\)\), "\[IndentingNewLine]", 
    \(DFT[a]\), "\[IndentingNewLine]", 
    \(1/Sqrt[12. ] InverseFourier[a] // Chop\), "\[IndentingNewLine]", 
    \(Fourier[a, FourierParameters \[Rule] {\(-1\), \(-1\)}] // Chop (*\ 
      no\ funciona\ en\ la\ versi\[OAcute]n\ 3.0\ *) \), \
"\[IndentingNewLine]", 
    \(Clear[a]\)}], "Input"],

Cell["\<\
No te debe caber duda de cu\[AAcute]l es el que hay que usar para hacer c\
\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Clear[lista]\[IndentingNewLine]
    \(lista = Table[Random[], {1024}];\)\[IndentingNewLine]
    \(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\  (*\ 
      visto\ y\ no\ visto\ *) \[IndentingNewLine]
    \(Timing[DFT[lista]]\)[\([1]\)]\)\( (*\ espera\ un\ poco, \ 
      ten\ paciencia; \ 
      hay\ que\ hacer\ m\[AAcute]s\ de\ un\ mill\[OAcute]n\ de\ operaciones\ *) \
\)\)\)], "Input"],

Cell[TextData[{
  "Ahora puedes apreciar el ahorro que proporciona el algoritmo de la \
transformada r\[AAcute]pida de Fourier. Pongamos a prueba el algoritmo con \
una muestra grande de ",
  Cell[BoxData[
      \(TraditionalForm\`2\^15 = 32678\)]],
  " datos. Solamente pretender almacenar la matriz de los \[Omega][n,N] para \
N=32678 ya ser\[IAcute]a un problema. "
}], "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {32678}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\), "\
\[IndentingNewLine]", 
    \(Clear[lista]\)}], "Input"],

Cell["No est\[AAcute] mal \[DownQuestion]verdad?.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Fourier Discreta y convoluci\[OAcute]n \
c\[IAcute]clica", "Section"],

Cell[TextData[{
  "Estudiemos ahora la relaci\[OAcute]n entre DFT y convoluci\[OAcute]n. \
Recuerda que, dados dos vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          "=", \((x\_0, x\_\(\(1\)\(,\)\) ... , x\_\(N - 1\))\)}], 
        TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          "=", \((y\_0, y\_\(\(1\)\(,\)\) ... , y\_\(N - 1\))\)}], 
        TraditionalForm]]],
  ", se define su convoluci\[OAcute]n circular o c\[IAcute]clica como el \
vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            FontWeight->"Bold"], "=", 
          StyleBox[
            RowBox[{"x", 
              FormBox[\(\(\ \)\(\[CircleDot]\)\),
                "TraditionalForm"], " ", "y"}],
            FontWeight->"Bold"]}], TraditionalForm]]],
  " dado por\n\n\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", GridBox[{
                {\(z\_0\)},
                {\(z\_1\)},
                {\(z\_2\)},
                {"..."},
                {\(z\_\(N - 1\)\)}
                }], ")"}], "  "}], TraditionalForm]]],
  "=  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 3\)\),
                 "...", "...", "...", "...", \(y\_1\)},
              {\(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), "...", 
                "...", "...", "...", \(y\_2\)},
              {\(y\_2\), \(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), "...", "...", "...",
                 "...", \(y\_3\)},
              {"...", "...", "...", "...", "...", "...", "...", "...", 
                "..."},
              {\(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 
                      3\)\), \(y\_\(N - 4\)\), "...", "...", "...", 
                "...", \(y\_0\)}
              }], ")"}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(x\_0\)},
              {\(x\_1\)},
              {\(x\_2\)},
              {"..."},
              {\(x\_\(N - 1\)\)}
              }], ")"}], TraditionalForm]]],
  "\n\t\t\t"
}], "Text"],

Cell[TextData[{
  "Las matrices como la anterior se llaman ",
  StyleBox["matrices circulantes",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"CirculantMatrix[lista]\" que construye una matriz \
circulante a partir de una lista dada. Usa para ello los comandos Transpose[ \
], RotateRight[ ], NestList[ ].\nb) Usando el comando anterior, define un \
comando \"CiclicConvolve[x,y]\" que calcule simb\[OAcute]licamente la \
convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"x", 
            FormBox["\[CircleDot]",
              "TraditionalForm"], " ", "y"}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nc) Comprueba simb\[OAcute]licamente para listas de 4 elementos que",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            RowBox[{
              FormBox[
                StyleBox[
                  RowBox[{"x", 
                    FormBox["\[CircleDot]",
                      "TraditionalForm"], " ", "y"}],
                  FontWeight->"Bold"],
                "TraditionalForm"], "=", \(y\[CircleDot]x\)}]}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nd) Comprueba simb\[OAcute]licamente para listas de N=4 elementos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(DFT[x\[CircleDot]\ y] = N\ DFT[x]\ DFT[y]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ListConvolve[n\[UAcute]cleo,lista]\" (consulta la \
ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que con un ajuste de par\[AAcute]metros permite calcular convoluciones c\
\[IAcute]clicas (aunque el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es mucho m\[AAcute]s general)."
}], "ExerciseText"],

Cell[BoxData[
    \(ListConvolve[{a, b, c, d}, {x, y, z, u}, 1]\)], "Input"],

Cell[TextData[{
  "\t    e) Comprueba con listas ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\)\(,\)\(y\)\(\ \)\)\)]],
  "generadas aleatoriamente de 1024 elementos cada una que "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`Fourier[ListConvolve[x, y, 1]] == \(\@1024\) 
        Fourier[x]\ *\ Fourier[y]\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Advertencia: debido a los errores de redondeo lo que puedes comprobar es \
que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Chop", "[", 
            
            FormBox[\(Fourier[ListConvolve[x, y, 1]] - \(\@1024\) 
                  Fourier[x]\ *\ Fourier[y]\),
              "TraditionalForm"], "]"}], "==", \(Table[0. , {1024}]\)}], 
        TraditionalForm]]]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define, usando el comando DFT[ ], un comando \
\"interpol[muestra][t,period]\" que calcule el polinomio \
trigonom\[EAcute]trico con periodo igual a \"period\" que interpola una \
\"muestra\" dada de valores. Comprueba que tu comando funciona correctamente \
con algunos ejemplos sencillos.\nSugerencia: se trata de calcular el \
polinomio dado por la igualdad (3). En su definici\[OAcute]n conviene usar \
los comandos ComplexExpand, Simplify y Chop\nb) Considera el polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = 
        0.8\ \(cos(400*2\ \[Pi]\ t)\) + 0.6\ \(sen(1600*2\ \[Pi]\ t)\) + 
          0.4\ \(cos(2400*2  \[Pi]\ t)\) + 0.2\ \(sen(3600*2  \[Pi]t)\)\)]],
  ".\nMuestrea ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " con una frecuencia apropiada, m\[UAcute]ltiplo de la frecuencia \
fundamental, durante un periodo y llama \"samples\" a los valores obtenidos.\n\
c) Recupera ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " a partir de \"samples\" usando el comando que has definido en el apartado \
a).\nd) Calcula, usando el comando \"inversaDFT[ ]\" definido en el ejercicio \
1, una lista, que llamar\[AAcute]s \"Ker\", de manera que la lista DFT[Ker\
\[CircleDot]samples] tenga los mismos elementos que DFT[samples] excepto los \
que corresponden a las frecuencias 2400 y 3600 que deben ser cero.\nd) \
Calcula el polinomio trigonom\[EAcute]trico que interpola los valores Ker\
\[CircleDot]samples con periodo 1/400 y comprueba que coincide con ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " en el que se han suprimido los t\[EAcute]rminos correspondientes a las \
frecuencias 2400 y 3600."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes o\[IAcute]r las funciones"
}], "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n te voy a presentar algunos comandos y herramientas \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que son \[UAcute]tiles para trabajar con se\[NTilde]ales de sonido. \
Comprobar\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata el sonido de forma parecida a las representaciones \
gr\[AAcute]ficas. No voy a proponerte ejercicios en esta secci\[OAcute]n."
}], "Text"],

Cell["El comando ListPlay[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que ListPlot[ ])  \
ListPlay[lista,opciones] donde \"lista\" puede ser cualquier lista de n\
\[UAcute]meros reales. Al ejecutar el comando los valores de la lista son \
convertidos en voltajes que se aplican al altavoz para producir el sonido. \
Una opci\[OAcute]n importante es \"SampleRate\", por defecto igual a 8192 \
(aunque puede variar de un ordenador a otro),  que indica el n\[UAcute]mero \
de valores que ser\[AAcute]n convertidos por segundo para reproducir el \
sonido. Otra opci\[OAcute]n es \"PlayRange\" que debe ajustarse dependiendo \
de la magnitud de los datos (la cual depende de la codificaci\[OAcute]n que \
se haya hecho de los mismos: 8 bits o 16 bits son las ususales). Aqu\[IAcute] \
tienes algunos ejemplos. Para reproducir el sonido en una celda Output de \
sonido la seleccionas con el rat\[OAcute]n y pulsas Alt+c+p (si haces doble \
click el sonido se reproduce continuamente).\
\>", "Text"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[1\/97, 1000]]]]\)\( (*\ 
      o\[IAcute]mos\ los\ primeros\ 1000\ d\[IAcute]gitos\ de\ la\ \
representaci\[OAcute]n\ decimal\ 1/
          97. \ Como\ se\ trata\ de\ un\ n\[UAcute]mero\ racional\ la\ lista\ \
tiene\ un\ per\[IAcute]odo\ que\ se\ repite\ y\ esa\ regularidad\ se\ refleja\
\ en\ el\ sonido\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[\[Pi], 1000]]]]\)\( (*\ 
      el\ n\[UAcute]mero\ \[Pi]\ no\ es\ racional\ y\ la\ sucesi\[OAcute]n\ \
de\ sus\ d\[IAcute]gitos\ decimales\ no\ tiene\ ninguna\ regularidad\ lo\ que\
\ se\ refleja\ en\ el\ sonido\ que\ se\ oye\ *) \)\)\)], "Input"],

Cell["\<\
Ahora puedes escuchar la aplicaci\[OAcute]n log\[IAcute]stica que usamos en \
la pr\[AAcute]ctica de iteraci\[OAcute]n y caos.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\(logistic[n_Integer] := 
        Module[{f, t, x}, \[IndentingNewLine]f = 
            Compile[{x, t}, Evaluate[\((3 + t\/n)\)\ x\ \((1 - x)\)]]; 
          FoldList[f, 0.223, Range[n]]];\)\[IndentingNewLine]
    \(ListPlay[logistic[8000], SampleRate \[Rule] 2000];\)\)\( (*\ 
      observa\ c\[OAcute]mo\ el\ sonido\ al\ principio\ es\ claro\ y\ n\
\[IAcute]tido\ y\ despu\[EAcute]s\ degenera\ en\ un\ ruido\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(ListPlay[Table[Sin[2\ \[Pi]\ 400. \ t], {t, 0, 1, 1/8000}]]\)], "Input"],

Cell["El comando Play[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que la de Plot[ ]) \
Play[funci\[OAcute]n,{t,min,max},opciones] y reproduce un sonido cuya \
amplitud est\[AAcute] dada por la funci\[OAcute]n en el tiempo en segundos \
comprendido entre \"min\" y \"max\". Adem\[AAcute]s de las opciones antes se\
\[NTilde]aladas para ListPlay[ ], v\[AAcute]lidas tambi\[EAcute]n para Play[ \
], hay otra opci\[OAcute]n interesante que es \"SampleDepth\", por defecto \
igual a 8, que indica el n\[UAcute]mero de bits que deben usarse para \
codificar los datos. Play[{funcion1,funcion2},{t,min,max},opciones] reproduce \
en est\[EAcute]reo. Ten en cuenta que el convertidor \
digital-anal\[OAcute]gico de la tarjeta de sonido de tu ordenador puede no \
soportar bien algunas tasas de muestreo lo que puede producir disonancias.\
\>", "Text"],

Cell[BoxData[
    \(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}, 
      SampleDepth \[Rule] 4]\)\( (*\ 
      observa\ la\ p\[EAcute]rdida\ de\ calidad\ en\ el\ sonido\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}];\)\( (*\ 
      la\ raz\[OAcute]n\ de\ muestreo\ por\ defecto\ es\ muy\ baja\ para\ \
reproducir\ bien\ esta\ funci\[OAcute]n\ cuya\ frecuencia\ es\ muy\ alta\ y\ \
queda\ enmascarada\ por\ otra\ m\[AAcute]s\ baja\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}, 
      SampleRate \[Rule] 12400]\)\( (*\ 
      usamos\ una\ raz\[OAcute]n\ de\ muestreo\ mayor\ que\ el\ doble\ de\ la\
\ frecuencia; \ ahora\ el\ sonido\ es\ m\[AAcute]s\ agudo\ *) \)\)\)], "Input"],

Cell["\<\
El siguiente comando se debe a Theodore Gray y reproduce una sucesi\[OAcute]n \
de sonidos sin interrupci\[OAcute]n entre ellos.\
\>", "Text"],

Cell[BoxData[{
    \(\(Attributes[
          CombinedSoundShow] = {HoldFirst};\)\), "\[IndentingNewLine]", 
    \(CombinedSoundShow[list_] := 
      Block[{llist}, \[IndentingNewLine]Block[{$DisplayFunction = 
              Identity, \ $SoundDisplayFunction = 
              Identity}, \[IndentingNewLine]\(llist = 
              list;\)]; \[IndentingNewLine]Show[
          Sound[Map[First, llist]]]]\)}], "Input"],

Cell[BoxData[
    \(CombinedSoundShow[{Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 0.25}], 
        Play[Sin[2\ \[Pi]\ 550\ t], {t, 0, 0.5}], 
        Play[Sin[2\ \[Pi]\ 880\ t], {t, 0,  .25}]}]\)], "Input"],

Cell["\<\
Finalmente, aqu\[IAcute] tienes un sonido estereof\[OAcute]nico (si dispones \
de altavoces apropiados).\
\>", "Text"],

Cell[BoxData[
    \(Play[{Sin[2\ \[Pi]\ 440\ t], Sin[2\ \[Pi]\ 822\ t]}, {t, 0, 
        1}]\)], "Input"],

Cell["\<\
Primitivas de sonido SampledSoundList[ ] y SampledSoundFunction[ ]\
\>", "Definition"],

Cell["\<\
De la misma manera que ListPlot[ ] y Plot[ ] dan como salida un objeto \
\"Graphics\", habr\[AAcute]s observado que la salida de los comandos \
PlayList[ ] y Play[ ] es un objeto \"Sound\".  An\[AAcute]logamente a \
\"Graphics\", un objeto \"Sound\" contiene una lista de primitivas de sonido \
que pueden reproducirse con Show[ ]. \
\>", "Text"],

Cell[BoxData[
    \(InputForm[ListPlay[Table[Tan[n], {n, 1, 25}]]]\)], "Input"],

Cell["\<\
Como puedes ver lo que hace el comando ListPlay[ ] es convertir los datos de \
la lista a n\[UAcute]meros reales comprendidos entre -1 y 1, pasar estos \
datos a la primitiva de sonido \"SampledSoundList\" y reproducirla con \
Show[Sound[SampledSoundList[ ]] ] ]. El objeto \"SampledSoundList\" es de la \
forma  \"SampledSoundList[lista,srate]\" su primer argumento es una lista de \
n\[UAcute]meros reales comprendidos entre -1 y 1 y su segundo argumento es la \
raz\[OAcute]n de muestreo, el n\[UAcute]mero de muestras que se convierten \
cada segundo para producir el sonido. \
\>", "Text"],

Cell["\<\
El objeto \"Sound\" que devuelve Play[ ] contiene como \[UAcute]nico elemento \
una primitiva de sonido que es \"SampledSoundFunction\" la cual se encarga de \
hacer, cada vez que se reproduce el sonido, la lista correspondiente de datos \
por medio de una funci\[OAcute]n compilada. Puedes comprobarlo ejecutando la \
siguiente celda.\
\>", "Text"],

Cell[BoxData[
    \(InputForm[Play[Sin[2\ \[Pi]\ 440\ \ x], {x, 0,  .5}]]\)], "Input"],

Cell[TextData[{
  "Es m\[AAcute]s c\[OAcute]moda para trabajar la primitiva \
\"SampledSoundList\" que, aunque ocupa m\[AAcute]s memoria, contiene la lista \
de datos como parte de ella lo que permite usar los comandos propios de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con listas. Por ejemplo, es inmediato revertir un sonido \
con el comando \"Reverse[ ]\" o extraer parte de \[EAcute]l o realizar un \
filtrado como veremos a continuaci\[OAcute]n."
}], "Text"],

Cell["\<\
El siguiente comando convierte un objeto \"SampledSoundFunction\" en \
\"SampledSoundList\".\
\>", "Text"],

Cell[BoxData[
    \(FunctionToList[
        sound_SampledSoundFunction] := \[IndentingNewLine]Module[{samps}, \
\[IndentingNewLine]samps = 
          Array[sound[\([1]\)], 
            sound[\([2]\)]]; \[IndentingNewLine]samps /= \((Max[Abs[samps]] + 
              0.00001)\); \[IndentingNewLine]Return[
          SampledSoundList[samps, sound[\([3]\)]]]]\)], "Input"],

Cell[BoxData[
    \(\(sinf = 
        Play[Sin[2\ \[Pi]\ 1000\ t], {t, 0,  .05}, 
          SampleRate \[Rule] 22050];\)\)], "Input"],

Cell[BoxData[{
    \(\(sinl = FunctionToList[sinf[\([1]\)]];\)\), "\[IndentingNewLine]", 
    \(\(Show[Sound[sinl]];\)\)}], "Input"],

Cell["Ciertamente que esto se puede hacer directamente.", "Text"],

Cell[BoxData[{
    \(\(tresenos = 
        SampledSoundList[
          Table[N[0.3 \((Sin[2\ \[Pi]\ 400\ x] + Sin[2\ \[Pi]\ 800\ x] + \ 
                    Sin[2\ \[Pi]\ 1600\ x])\)], {x, 0, 0.25, 1/22050}], 
          22050];\)\), "\[IndentingNewLine]", 
    \(\(Show[Sound[tresenos]];\)\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{Sound[FunctionToList[sinf[\([1]\)]]], 
          Sound[tresenos], 
          Sound[FunctionToList[sinf[\([1]\)]]]}];\)\)], "Input"],

Cell[BoxData[
    \(Clear[sinf, sinl, tresenos]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trabajar con archivos de sonido", "Section"],

Cell[TextData[{
  "Puedes importar archivos de sonido con el comando \
Import[\"C:/archivo.ext\"] (debes dar la ruta completa del archivo o bien \
decir a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que trabaje en la carpeta donde est\[AAcute] el archivo lo que se hace \
con SetDirectory[ ]). Con esta pr\[AAcute]ctica habr\[AAcute]s bajado el \
archivo pavrti.wav. Antes de seguir establece el directorio de trabajo."
}], "Text"],

Cell[BoxData[
    \(\(SetDirectory["\<D:/Docencia \
Informatica/Javier/Ingenieria_Informatica/Curso2005_2006/Calculo_Avanzado/\
Practicas/\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      especifica\ aqu\[IAcute]\ la\ ruta\ al\ directorio\ que\ contiene\ el\ \
archivo\ pavrti . wav . \ 
          Por\ ejemplo\ \
*) \)\(\[IndentingNewLine]\)\(SetDirectory["\<C:/calculo_avanzado/Practicas\>\
"]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(dorma = 
      Import["\<pavrti.wav\>"]\)\(;\)\( (*\ \[DownExclamation]no\ quites\ el\ \
; ! \ *) \)\)\)], "Input"],

Cell[TextData[{
  "Puedes ver la forma en que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa el archivo importado como un objeto de sonido \"Sound\" que \
consta de una \[UAcute]nica primitiva \"SampledSoundList\"."
}], "Text"],

Cell[BoxData[
    \(\(\(Short[InputForm[dorma]]\)\( (*\ 
      observa\ que\ la\ tasa\ de\ muestreo\ es\ 8000\ *) \)\)\)], "Input"],

Cell["\<\
La lista de datos es el primer argumento de \"SampledSoundList\", es decir \
nesdorma[[1,1]]. Es demasiado grande para sacarlo en pantalla.\
\>", "Text"],

Cell[BoxData[
    \(Length[dorma[\([1, 1]\)]]\)], "Input"],

Cell["Pero podemos representarlo gr\[AAcute]ficamente con ListPlot[ ].", \
"Text"],

Cell[BoxData[
    \(\(ListPlot[dorma[\([1, 1]\)], PlotRange \[Rule] All];\)\)], "Input"],

Cell["\<\
Como ves son datos comprendidos entre -1 y 1 y su aspecto resulta familiar; \
recuerda las im\[AAcute]genes que salen en la grabadora de sonidos de \
Windows. Podemos reproducir el archivo.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlay[dorma[\([1, 1]\)]];\)\)], "Input"],

Cell["Tambi\[EAcute]n pdemos hacerlo directamente.", "Text"],

Cell[BoxData[
    \(\(Show[dorma];\)\)], "Input"],

Cell["\[DownQuestion]Tienes curiosidad por escucharlo de atr\[AAcute]s \
adelante?", "Text"],

Cell[BoxData[
    \(\(ListPlay[Reverse[dorma[\([1, 1]\)]]];\)\)], "Input"],

Cell["\[DownQuestion]C\[OAcute]mo sonar\[AAcute] el cuadrado?", "Text"],

Cell[BoxData[
    \(\(ListPlay[dorma[\([1, 1]\)]^2];\)\)], "Input"],

Cell[TextData[{
  "Pues suena bastante mal. Pero lo ya visto muestra las muchas posibilidades \
para trabajar con archivos de sonido. ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "tiene un paquete que es bastante \[UAcute]til para obtener informaci\
\[OAcute]n adicional de un archivo de sonido (al menos a partir de la versi\
\[OAcute]n 5, no s\[EAcute] si antes estaba  disponible). "
}], "Text"],

Cell["<< Miscellaneous`Audio`", "Input",
  CellTags->"S5.51.1"],

Cell[TextData[{
  "Este paquete carga, entre otros, el comando \
\"ReadSoundFile[\"archivo.ext\", PrintHeader",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "True]\" que lee el archivo de sonido especificado y lo convierte en una \
lista de enteros comprendidos entre -32768 y +32767 (codificaci\[OAcute]n de \
16 bits). Adem\[AAcute]s, y esto es lo interesante, proporciona la informaci\
\[OAcute]n contenida en la cabecera del archivo."
}], "Text"],

Cell[BoxData[
    \(\(\(nessundorma = 
      ReadSoundFile["\<pavrti.wav\>", 
        PrintHeader \[Rule] 
          True]\)\(;\)\( (*\ \[DownExclamation]no\ quites\ el\ ; ! \ *) \
\)\)\)], "Input"],

Cell[TextData[{
  "El archivo importado lo representa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplemente como una lista sin m\[AAcute]s informaci\[OAcute]n \
adicional."
}], "Text"],

Cell[BoxData[
    \(Head[nessundorma]\)], "Input"],

Cell[BoxData[
    \(Length[nessundorma]\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[nessundorma, PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlay[Take[nessundorma, 25000]];\)\)], "Input"],

Cell[TextData[{
  "Podemos exportar archivos de sonido en varios formatos con el comando \
\"Export[\"archivo.ext\",expr]\". Este comando est\[AAcute] disponible a \
partir de la versi\[OAcute]n 4 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Dependiendo del tipo de conversi\[OAcute]n de datos que se haga se puede \
perder bastante calidad en el sonido."
}], "Text"],

Cell[BoxData[
    RowBox[{
      TagBox[
        FrameBox[\(Export["\<dormashort.wav\>", 
            Sound[SampledSoundList[Take[dorma[\([1, 1]\)], 25000], 8000]]]\),
          BoxFrame->False,
          BoxMargins->False],
        Short], ";", \( (*\ no\ se\ pierde\ calidad\ *) \)}]], "Input"],

Cell[BoxData[
    RowBox[{
      TagBox[
        FrameBox[\(Export["\<nessundormashort.wav\>", \
\[IndentingNewLine]Sound[
              SampledSoundList[N[Take[nessundorma, 25000]/32768], 8000]]]\),
          BoxFrame->False,
          BoxMargins->False],
        Short], 
      ";", \( (*\ 
        si\ no\ tienes\ la\ precauci\[OAcute]n\ de\ dividir\ por\ 32768\ para\
\ situar\ los\ datos\ en\ el\ intervalo\ [\(-1\), 1], \ 
        el\ archivo\ que\ resulta\ pierde\ mucha\ calidad\ de\ sonido\ *) \
\)}]], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 5: Decodificaci\[OAcute]n de un archivo de sonido", "Exercise"],

Cell[TextData[{
  "Con esta pr\[AAcute]ctica has bajado el archivo \"codificado.wav\" que, \
como su nombre indica, es un archivo de sonido (voz humana) que se ha \
codificado. Voy a decirte los pasos que he seguido para codificarlo y tu \
trabajo va a consistir en invertir el proceso para recuperar el archivo \
original. \n1. He le\[IAcute]do el arhivo original usando el comando \
ReadSoundFile[ ], el mismo que t\[UAcute] debes usar para leer el archivo \
codificado.\n2. He revertido el archivo original.\n3. Haciendo uso de la \
transformada de Fourier discreta (Fourier[ ]) he mezclado como sigue las \
frecuencias del archivo revertido. He considerado cuatro partes ",
  StyleBox["a, b, c y d",
    FontWeight->"Bold"],
  ", de la transformada  correspondientes cada una de ellas a un cuarto de \
las frecuencias presentes en la transformada. Es decir si, por ejemplo, es H \
la m\[AAcute]xima frecuencia que puede detectar la transformada de Fourier, \
entonces ",
  StyleBox["a",
    FontWeight->"Bold"],
  " corresponde a los coeficientes asociados al rango de frecuencias [1, \
H/4], ",
  StyleBox["b",
    FontWeight->"Bold"],
  " corresponde a los ceficientes asociados al rango de frecuencias [H/4+1, \
H/2] y an\[AAcute]logamente ",
  StyleBox["c",
    FontWeight->"Bold"],
  " y ",
  StyleBox["d",
    FontWeight->"Bold"],
  ".\n4. He formado una nueva lista \"scramble\" mezclando las frecuencias en \
la secuencia ",
  StyleBox["d,c,b,a",
    FontWeight->"Bold"],
  ". \n5. He tomado transformada de Fourier inversa para obtener la lista \
\"invdftscramble\".\n6. Finalmente, con el siguiente comando, he creado el \
archivo codificado."
}], "Text"],

Cell[BoxData[{\(m = Max[Abs[invdftscramble]];\), "\[IndentingNewLine]", 
    TagBox[
      FrameBox[\(Export["\<codificado.wav\>", 
          Sound[SampledSoundList[invdftscramble/m, 12000]]]\),
        BoxFrame->False,
        BoxMargins->False],
      Short]}], "Input"],

Cell[TextData[{
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". No te he dicho todos los detalles del proceso porque tu trabajo consiste \
en \[EAcute]so, en completar los detalles que omito. Ten en cuenta lo \
siguiente. Debes dar los mismos (los \"sim\[EAcute]tricos\") pasos que yo \
pero en orden inverso. Ten muy presente que la segunda mitad de la \
transformada de Fourier no aporta nuevas frecuencias, las frecuencias est\
\[AAcute]n en la primera mitad de la transformada (si tiras a la basura una \
parte - casi la mitad - de la transformada no pierdes informaci\[OAcute]n). \
Hay dos coeficientes que requieren un trato especial (hay que dejarlos en su \
sitio). Ten en cuenta que cuando apliques transformada inversa debes obtener \
una se\[NTilde]al real, por lo que al reconstruir las frecuencias a sus \
lugares de origen debes construir una lista que sea hemisim\[EAcute]trica \
(este \"palabro\" est\[AAcute] definido al principio de esta \
pr\[AAcute]ctica). Un \[UAcute]ltimo detalle, ya casi te lo digo todo, ",
  StyleBox["b, c",
    FontWeight->"Bold"],
  " y ",
  StyleBox["d",
    FontWeight->"Bold"],
  " tienen igual n\[UAcute]mero de elementos, ",
  StyleBox["a",
    FontWeight->"Bold"],
  " tiene uno menos que ellos. "
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado de se\[NTilde]ales de sonido", "Section"],

Cell[TextData[{
  "Sabemos que los filtros (sistemas lineales invariantes en el tiempo y \
continuos)  act\[UAcute]an por convoluci\[OAcute]n. Te lo recuerdo \
brevemente. Si ",
  Cell[BoxData[
      \(TraditionalForm\`L\)]],
  " es un filtro y \[Delta] es la funci\[OAcute]n impulso unidad discreta, \
esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[NotEqual] \ 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](0) = 1\)]],
  "; se llama ",
  StyleBox["respuesta impulso",
    FontWeight->"Bold"],
  " del filtro a la se\[NTilde]al ",
  Cell[BoxData[
      \(TraditionalForm\`h(n) = L(\[Delta](n))\)]],
  ". Si ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "=", \(x(n)\)}], TraditionalForm]]],
  " es una se\[NTilde]al cualquiera tenemos que:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"L", "(", 
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox[")",
            FontWeight->"Plain"]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox["L",
              FontWeight->"Plain"], 
            StyleBox["(",
              
              FontWeight->
                "Plain"], \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(
                  k)\) \(\[Delta](n - k)\)\), ")"}], 
          "=", \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(
                  k)\) \(L(\[Delta](
                    n - k))\) = \[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\
\( x(k)\) \(h(n - k)\)\)}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La convoluci\[OAcute]n de dos se\[NTilde]ales discretas ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, \ y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dada para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckZ]\)]],
  " por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["\[Star]",
            FontWeight->"Bold"], \(y(n)\)}], 
        "=", \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\( x(k)\) \(y(
              n - k)\)\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Por tanto, la respuesta de un filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(x(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " se obtiene por convoluci\[OAcute]n de dicha se\[NTilde]al con la \
respuesta impulso del filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", \(h \((n)\)\)}], TraditionalForm]]],
  ". Si, adem\[AAcute]s el filtro es ",
  StyleBox["causal",
    FontSlant->"Italic"],
  ", es decir, la salida del sistema en cualquier instante ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`y(n)\)]],
  ") depende s\[OAcute]lo de las entradas presentes y pasadas (es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`x(n), \ x(n - 1), \ x(n - 2),  ... \)]],
  "), entonces debe ocurrir que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(h(n)\)\(=\)\(0\)\(\ \)\)\)]],
  "para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  ". Si, adem\[AAcute]s, la funci\[OAcute]n respuesta impulso del filtro es \
de duraci\[OAcute]n finita, esto es, si ",
  Cell[BoxData[
      \(TraditionalForm\`h(n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] M\)]],
  " entonces tenemos lo que se llama un filtro de respuesta impulso finita \
(FIR) causal. La acci\[OAcute]n de dicho filtro viene dada por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
            n - k)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((3)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Llegados a este punto, una hip\[OAcute]tesis usual en tratamiento digital \
de se\[NTilde]ales es que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", \(x(n)\)}]}], TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita que la respuesta impulso y que ambas \
se\[NTilde]ales son peri\[OAcute]dicas con per\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ". En estas hip\[OAcute]tesis (que comentaremos en la secci\[OAcute]n \
siguiente) la convoluci\[OAcute]n dada por (3) es de hecho ",
  StyleBox["una convoluci\[OAcute]n c\[IAcute]clica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((x(0), x(1), x(2),  ... , x(M - 1))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((h(0), h(1), h(2),  ... , h(M - 1))\)\)]],
  ". Podemos por ello representar la acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; tomando transformadas de Fourier discretas, como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto, obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama ",
  StyleBox["funci\[OAcute]n de transferencia",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " del filtro y es la DFT de la funci\[OAcute]n respuesta impulso. "
}], "Text"],

Cell[TextData[{
  "El dise\[NTilde]o de filtros en el dominio de la frecuencia consiste en \
definir una funci\[OAcute]n de transferencia que haga el trabajo deseado. Si, \
por ejemplo, queremos dejar pasar unas determinadas frecuencias sin alterar y \
eliminar las frecuencias restantes, nuestra funci\[OAcute]n de transferencia \
tendr\[AAcute] un 1 en los lugares correspondientes a las frecuencias que \
queremos dejar inalteradas y un 0 en los dem\[AAcute]s lugares; de esta forma \
el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dejar\[AAcute] iguales los lugares (las componentes) de ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  " correspondientes a las frecuencias que queremos dejar pasar inalteradas y \
en los dem\[AAcute]s lugares aparecer\[AAcute] un 0 eliminando de esa forma \
las frecuencias no deseadas. Una vez construida la funci\[OAcute]n de \
transferencia, la respuesta del filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " en el dominio del tiempo se obtiene calculando la DFT inversa de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; de hecho ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["M",
            FontWeight->"Bold"]], TraditionalForm]]],
  " es un factor de escala que suele ignorarse en la pr\[AAcute]ctica. \
Alternativamente, una vez obtenida ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se puede obtener, por DFT inversa, la funci\[OAcute]n respuesta impulso \
",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " y puede obtenerse la respuesta del filtro a una se\[NTilde]al de entrada \
",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " por medio de la convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; pero este m\[EAcute]todo es menos eficiente que el basado en la DFT que \
consiste en calcular ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  ", multiplicar por ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " y por ",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "y tomar DFT inversa",
  StyleBox[". ",
    FontWeight->"Bold"],
  "En la pr\[AAcute]ctica se ignora",
  StyleBox[" ",
    FontWeight->"Bold"],
  "el factor de escala ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; por ejemplo, si la se\[NTilde]al representa un sonido, multiplicarla por \
un n\[UAcute]mero positivo es algo que no se puede apreciar cuando se \
reproduce; adem\[AAcute]s la mayor\[IAcute]a de los formatos de sonido \
ajustan los valores a un intervalo prefijado.",
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "En este ejercicio te propongo que dise\[NTilde]es un filtro de paso banda. \
Se trata de definir una funci\[OAcute]n \"filtropasobanda[sound_,fmin_,fmax_]\
\" donde se entiende que \"sound\" es la se\[NTilde]al de entrada, \
[fmin,fmax] es el intervalo de frecuencias que se van a dejar pasar \
inalteradas y las dem\[AAcute]s frecuencias se van a eliminar. Es importante \
en la se\[NTilde]al de entrada conocer la raz\[OAcute]n de muestreo (el n\
\[UAcute]mero de muestras por segundo) pues ello afecta de forma notable a la \
DFT; ya sabes que  las frecuencias en la DFT son relativas al tama\[NTilde]o \
de la muestra, al multiplicar por dos la longitud de la muestra pasando de ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " a 2",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos manteniendo fija la raz\[OAcute]n de muestreo, los \[IAcute]ndices \
",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " correspondientes a las frecuencias presentes en la muestra \
tambi\[EAcute]n quedan multiplicados por dos. En consecuencia habr\[AAcute] \
que ajustar \"fmin\" y \"fmax\" teniendo en cuenta el cociente \
longitud[muestra]/(razondemuestreo). \nEn vista de lo dicho, parece apropiado \
que \"sound\" sea de la forma sound=SoundSampledList[ ] pues as\[IAcute] \
tenemos todo junto: la lista de datos, que ser\[AAcute] sound[[1]], y la raz\
\[OAcute]n de muestreo, que ser\[AAcute] sound[[2]]. Adem\[AAcute]s es f\
\[AAcute]cil generar objetos de la forma \"SoundSampledList[ ]\"a los que \
podremos aplicar nuestro filtro.\nAparte de este detalle, hay otro aspecto t\
\[EAcute]cnico derivado del hecho de que la DFT (el algoritmo de la \
transformada r\[AAcute]pida de Fourier) trabaja mucho m\[AAcute]s \
r\[AAcute]pido con muestras cuyo tama\[NTilde]o es producto de \
n\[UAcute]meros primos peque\[NTilde]os (2, 3, 5). Por eso es conveniente \
poder ajustar el tama\[NTilde]o de la muestra a\[NTilde]adiendo ceros hasta \
lograr que tenga un tama\[NTilde]o \[OAcute]ptimo. \na) Define una lista \
ordenada de menor a mayor con todos los n\[UAcute]meros ",
  StyleBox["pares",
    FontSlant->"Italic"],
  " de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`2\^i\ \(3\^j\) 5\^k\)]],
  "que sean menor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`32768 = 2\^15\)]],
  ". Llama a esa lista \"sizes\".\nb) Define una funci\[OAcute]n \
\"eligesize[z_]\" cuyo argumento es un n\[UAcute]mero (que ser\[AAcute] la \
longitud de la lista x[[1]]) que haga lo siguiente:\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z \[LessEqual] p = Max[sizes]\)]],
  ", entonces \"eligesize[z]\" proporciona el primer elemento de la lista \
\"sizes\" que es mayor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ".\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z > p\)]],
  ", se calcula el entero positivo ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " m\[AAcute]s peque\[NTilde]o tal que ",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q \[LessEqual] p\)]],
  " y \"eligesize[z]\" es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`2\^q\)]],
  " multiplicado por el primer elemento de \"sizes\" que es mayor o igual que \
",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q\)]],
  ".\nSugerencias: Esta funci\[OAcute]n es bien f\[AAcute]cil de definir. Los \
comandos \"Ceiling[ ]\", \"First[ ]\", \"Select[ ]\" pueden ser \
\[UAcute]tiles.\nc) Define la funci\[OAcute]n \
\"filtropasobanda[sound_SampledSoundList,fmin_,fmax_]\" que debe \
proporcionarte como salida otro objeto \"SampledSoundList[ ]\". Sigue los \
siguientes pasos:\nc1) Define variables locales: \"muestras=sound[[1]]\", \
\"srate=sound[[2]]\", \"newsize\", \"transfer\", \"newfmin\", \
\"newfmax\",\"origsize=Length[sound[[1]]]\", n.\nc2) Optimiza el \
tama\[NTilde]o de la lista \"muestras\" con \"newsize=2*eligesize[ ]\" (No es \
imprescindible multiplicar por 2 pero el resultado del filtro me ha parecido \
mejor as\[IAcute]. Ver Nota en la siguiente secci\[OAcute]n).\nc3) Agrega \
ceros al final de la lista \"muestras\" hasta que la longitud sea igual a \
\"newsize\". A la nueva lista obtenida le sigues llamando \"muestras\".\nc4) \
Define \"newfmin\" y \"newfmax\" teniendo en cuenta los valores \"fmin\" y \
\"fmax\" el tama\[NTilde]o \"newsize\" y \"srate\".\nc5) Define la funci\
\[OAcute]n de transferencia \"transfer\" que debe ser una lista de longitud \
\"newsize\" con elementos igual a 1 en los lugares ",
  Cell[BoxData[
      \(TraditionalForm\`newfmin \[LessEqual] \ n \[LessEqual] newfmax\)]],
  " y 0 en los restantes. Ten en cuenta que la funci\[OAcute]n de \
transferencia debe ser \"par\" para que pueda actuar de forma apropiada sobre \
la DFT de \"muestras\". Ten en cuenta que la mayor frecuencia presente es \
\"newsize/2+1\" (recuerda que \"newsize\" siempre es par). La idea es definir \
\"transfer\" para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`n \[LessEqual] \ newsize/2 + 1\)]],
  " y simetrizar de forma adecuada. Pueden ser de utilidad los comandos \
\"Join[ ]\" (usado con cuidado), \"Take[ ]\", \"Reverse[ ]\". \nc6) El \
trabajo que queda lo har\[AAcute] el algoritmo de la transformadad \
r\[AAcute]pida de Fourier. Se trata de obtener en el dominio del tiempo la se\
\[NTilde]al que devuelve el filtro. Esta se\[NTilde]al vamos a llamarla tambi\
\[EAcute]n \"muestras\" y viene dada como ya hemos explicado arriba. Hay un \
detalle y es que debes tomar de la se\[NTilde]al resultante los primeros \
\"origsize\" elementos. Y otro detalle: usa \"Chop[ ]\" y toma parte real \
\"Re[ ]\" para evitar errores de redondeo.\nc7) Un \[UAcute]ltimo detalle: \
asegurarnos de que los datos devueltos est\[AAcute]n comprendidos entre -1 y \
1 (podr\[IAcute]a haber sucedido algo raro debido a errores de redondeo). \
Para ello basta poner \"muestras /= Max[Abs[muestras]]\".\nc8) El \
\[UAcute]ltimo paso es construir el objeto \"SampledSoundList[ ]\" que \
devuelve nuestra funci\[OAcute]n. Te lo digo yo. Basta escribir \
Return[SampledSoundList[muestras,srate]]. \nEso es todo. Es much\[IAcute]simo \
m\[AAcute]s largo y m\[AAcute]s dif\[IAcute]cil explicarlo que hacerlo."
}], "ExerciseText"],

Cell["Prueba el filtro que has definido con la siguiente muestra.", "Text"],

Cell[BoxData[
    \(\(senos = 
        SampledSoundList[
          Table[N[0.3\ \((Sin[2\ Pi\ 400. \ x] + Sin[2\ Pi\ 1600. \ x] + 
                    Sin[2\ Pi\ 3600. \ x])\)], {x, 0, 1 - 1/22500.0, 
              1/22500.0}], 22500];\)\)], "Input"],

Cell["\<\
Filtra primero dejando pasar solamente la frecuencia m\[AAcute]s baja, despu\
\[EAcute]s dejando pasar s\[OAcute]lo la frecuencia media y finalmente \
dejando pasar solamente la m\[AAcute]s alta. Ponle nombres a los objetos \
SampledSoundList[ ] que obtienes de esta forma y reprod\[UAcute]celos \
individualmente con Show[Sound[\"nombre\"]] y conjuntamente con el comando \
CombinedSoundShow[ ].\
\>", "Text"],

Cell["\<\
Ahora prueba con el archivo \"pavrti.wav. Lo importas y le pones de nombre \
\"pavrti\". Despu\[EAcute]s puedes hacer lo que te sugiero para ver \
c\[OAcute]mo el filtro selecciona frecuencias.\
\>", "Text"],

Cell[BoxData[{
    \(\(pavrtibajo = filtropasobanda[pavrti[\([1]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[pavrtibajo]];\)\), "\n", 
    \(\(pavrtimedio = 
        filtropasobanda[pavrti[\([1]\)], 1000, 2000];\)\), "\n", 
    \(\(Show[Sound[pavrtimedio]];\)\), "\n", 
    \(\(pavrtialto = 
        filtropasobanda[pavrti[\([1]\)], 2000, 8000];\)\), "\n", 
    \(\(Show[Sound[pavrtialto]];\)\), "\n", 
    \(\(CombinedSoundShow[{pavrti, Sound[pavrtibajo], Sound[pavrtimedio], 
          Sound[pavrtialto]}];\)\)}], "Input"],

Cell["\<\
Esto casi se aprecia mejor en archivos de voz. Con esta pr\[AAcute]ctica habr\
\[AAcute]s bajado un archivo \"papa.wav\" que contiene la voz de un ni\
\[NTilde]o, hijo de un compa\[NTilde]ero mio, que dice muy alegre \"Pap\
\[AAcute], me gusta el ordenador...\" (quiz\[AAcute]s as\[IAcute] empezaste t\
\[UAcute] y mira d\[OAcute]nde est\[AAcute]s ahora...). Importa el archivo y \
ponle nombre, por ejemplo, \"ninio\" y p\[AAcute]sale el filtro para \
seleccionar frecuencias bajas entre 0 y 1000 hercios, frecuencias medias \
entre 1000 y 2000 hercios y frecuencias altas entre 2000 y 4000 hercios. Ver\
\[AAcute]s que los cambios en la voz son muy notables.\
\>", "Text"],

Cell["\<\
Ya te habr\[AAcute]s dado cuenta que el filtro que hemos construido sirve \
tambi\[EAcute]n como filtro paso bajo y como filtro paso alto: basta para \
ello elegir el rango de frecuencias apropiado. \
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado lineal (esto es para quienes quieran saber m\[AAcute]s)", \
"Section"],

Cell["\<\
En la secci\[OAcute]n anterio, al llegar a la igualdad de convoluci\[OAcute]n \
(convoluci\[OAcute]n que  a veces se llama \"lineal\" para distinguirla de la \
convoluci\[OAcute]n circular)\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
            n - k)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((3)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se supuso que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", \(x(n)\)}]}], TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita que la respuesta impulso y que ambas \
se\[NTilde]ales son (muestras de se\[NTilde]ales) peri\[OAcute]dicas con per\
\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ". Pong\[AAcute]monos ahora en el caso general en que no se supone \
periodicidad y supongamos que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(x(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " tiene longitud ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`x(n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] Q\)]],
  ". Entonces la duraci\[OAcute]n de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(y(n)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  " dada por la igualdad (3) es ",
  Cell[BoxData[
      \(TraditionalForm\`Q + M - 1\)]],
  ". Pues podemos escribir"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y(
        n) = \(\[Sum]\+\(k = 0\)\%\(M - 1\)\(h(k)\) \(x(
              n - k)\) = \[Sum]\+\(\(k + j = n\)\(,\)\(\ \)\((k + j \
\[LessEqual] M + Q - 2)\)\(\ \)\)\(h(k)\) \(x(
              j)\)\ \ \ \ \ \ \ \ \ \ \((3)\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`y(n)\)]],
  " es igual al coeficiente de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  " en el producto de los polinomios de grados ",
  Cell[BoxData[
      \(TraditionalForm\`M - 1\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`Q - 1\)]],
  ":"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((\(h(0) + \(h(1)\) x + \(h(2)\) x\^2 + \(h(3)\) 
                x\^3 +  ... \) + \(h(M - 1)\) 
            x\^\(M - 1\))\) \((\(x(0) + \(x(1)\) x + \(x(2)\) 
                x\^2 +  ... \) + \(x(Q - 1)\) x\^\(Q - 1\))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El resultado del producto es un polinomio de grado ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 2\)]],
  " que tiene ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  " coeficientes que ser\[AAcute] la longitud de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ".",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " tiene un comando bastante r\[AAcute]pido y eficaz que calcula los \
coeficientes de un producto de polinomios (el comando \"ListConvolve[ ] no se \
adapta para este c\[AAcute]lculo)."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ vamos\ a\ considerar\ que\ x \((0)\) = 1, \ 
      x \((1)\) = \(-2\), \ x \((2)\) = 1, \ x \((3)\) = \(-1\), \ 
      son\ los\ valores\ no\ nulos\ de\ la\ se\[NTilde]al\ x, \ 
      h \((0)\) = 2, \ h \((2)\) = \(-1\), \ 
      h \((7)\) = \(\(-1\)\ son\ los\ valores\ no\ nulos\ de\ la\ \
se\[NTilde]al\ h . \ Tenemos\ que\ M = 8\), \ 
      Q = 4\ *) \)\(\[IndentingNewLine]\)\(CoefficientList[\((1 - 2  z + 
            z\^2 - z\^3)\)*\((2 - z\^2 - z\^7)\), z]\)\( (*\ 
      una\ forma\ de\ calcular\ x\[Star]h\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Con esta interpretaci\[OAcute]n, es evidente que si a\[NTilde]adimos \
valores nulos de las se\[NTilde]ales ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  "  y los hacemos intervenir en los c\[AAcute]lculos, la convoluci\[OAcute]n \
resultante es la misma que la anterior con ceros a\[NTilde]adidos al final."
}], "Text"],

Cell[BoxData[
    \(CoefficientList[\((1 - 2  z + z\^2 - z\^3 + 0. \ z\^4 + 0.  z\^5 + 
            0.  z\^6 + 0.  z\^7)\)*\((2 - z\^2 - z\^7)\), z]\)], "Input"],

Cell[TextData[{
  "Lo anterior tiene por objetivo ver que la convoluci\[OAcute]n (3) podemos \
expresarla como una convoluci\[OAcute]n c\[IAcute]clica. Para ello lo que \
hacemos es calcular la convoluci\[OAcute]n de las se\[NTilde]ales de igual \
longitud ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x(k), \ h(k), \ 
      0 \[LessEqual] k \[LessEqual] M + Q - 1\)]],
  ", es decir consideramos algunos t\[EAcute]rminos adicionales nulos, y la \
convoluci\[OAcute]n c\[IAcute]clica correspondiente es justamente ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}, {2, 
        0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}, 1]\)], "Input"],

Cell["\<\
Comprueba el resultado anterior con el comando \"CiclicConvolve[ ]\" que has \
definido en el ejercicio 3.\
\>", "Text"],

Cell[BoxData[
    \(CiclicConvolve[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}, {2, 
        0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}]\)], "Input"],

Cell[BoxData[
    \(Fourier[{2, \(-4\), 1, 0, \(-1\), 1, 0, \(-1\), 2, \(-1\), 1}] - \@11*
          Fourier[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}]*
          Fourier[{2, 0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}] // 
      Chop\)], "Input"],

Cell[TextData[{
  "Con lo anterior hemos justificado que todo filtro en las condiciones \
consideradas, sin m\[AAcute]s que a\[NTilde]adir ceros en la forma que se ha \
indicado, act\[UAcute]a por convoluci\[OAcute]n c\[IAcute]clica. Es aqu\
\[IAcute] donde entra, ya era hora, la DFT. Podemos por ello representar la \
acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; donde ahora ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " son vectores de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N = M + Q - 1\)]],
  ". Tomando transformadas de Fourier discretas como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@N\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama funci\[OAcute]n de transferencia del filtro y es la DFT de la \
funci\[OAcute]n impulso respuesta (de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "). Este procedimiento se conoce como ",
  StyleBox["filtrado lineal.",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Nota: En la definici\[OAcute]n del filtro de la secci\[OAcute]n anterior, \
no es imprescindible multiplicar por 2 para definir \"newsize\", pero hacerlo \
mejora los resultados del filtro y asegura que a\[NTilde]adiremos suficientes \
ceros para que la convoluci\[OAcute]n c\[IAcute]clica de la nueva muestra con \
ceros a\[NTilde]adidos represente al filtro sin necesidad de \
hip\[OAcute]tesis de periodicidad. Oberva que la longitud de la \
funci\[OAcute]n de transferencia es \"newfmax\"-\"newfmin\" y la longitud \
\"newsize\" debe verificar que \
\"newsize\"\[GreaterEqual]\"origsize\"+\"newfmax\"-\"newfmin\"-1; si al \
elegir \"newsize\" se multiplica por 2, esta condici\[OAcute]n se cumple \
siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`"fmax" - "fmin" \[LessEqual] srate\/2\)]],
  " lo que normalmente se satisface."
}], "Text"],

Cell["\<\
Hay que advertir que los dos m\[EAcute]todos no son equivalentes. \
Ve\[AAcute]moslo con un ejemplo.\
\>", "Text"],

Cell["Comparaci\[OAcute]n de los m\[EAcute]todos de filtrado lineal y peri\
\[OAcute]dico", "Definition"],

Cell[TextData[{
  "Consideremos un filtro cuya ",
  StyleBox["funci\[OAcute]n impulso",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " venga dada como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(funpulso = 
        Table[Exp[\(-0.01\)\ t], {t, 0, 511}]/\((Plus @@ 
              Table[Exp[\(-0.01\)\ t], {t, 0, 511}])\);\)\), "\n", 
    \(\(ListPlot[funpulso];\)\)}], "Input"],

Cell["Consideremos una se\[NTilde]al que vamos a generar aleatoriamente.", \
"Text"],

Cell[BoxData[
    \(\(\(\(signal = 
        NestList[#1\ If[Random[] < 0.01, \(-1.0\), 1.0] &, 1, 511];\)\n
    \(\(\(ListPlot[signal]\)\(\ \)\);\)\)\( (*\ 
      cada\ vez\ que\ ejecutes\ el\ comando\ saldr\[AAcute]\ una\ \
se\[NTilde]al\ distinta . \ 
          Trata\ de\ obtener\ una\ que\ te\ guste\ *) \)\)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Observa que \"signal\" y \"funpulso\" tiene igual longitud 512. La respuesta \
de este filtro a \"signal\" se puede obtener interpretando que hay \
periodicidad por convoluci\[OAcute]n c\[IAcute]clica, lo que a su vez podemos \
hacer directamente o, indirectamente usando la DFT y su inversa (cuando los c\
\[AAcute]lculos son muy largos este procedimiento es el m\[AAcute]s eficaz). \
\
\>", "Text"],

Cell[BoxData[{
    \(\(respuesta = 
          Chop[Sqrt[512] 
              InverseFourier[Fourier[signal]*\ Fourier[funpulso]]];\) // 
      Timing\), "\[IndentingNewLine]", 
    \(\(respuesta2 = Chop[ListConvolve[signal, funpulso, 1]];\) // 
      Timing\)}], "Input"],

Cell[BoxData[{
    \(respuesta \[Equal] respuesta2\  (*\ puede\ dar\ False, \ 
      depende\ de\ la\ se\[NTilde]al\ que\ se\ genere\ *) \), "\n", 
    \(Chop[respuesta - respuesta2] \[Equal] 
      Table[0, {512}]\), "\[IndentingNewLine]", 
    \( (*\ 
      suelen\ producirse\ peque\[NTilde]os\ errores\ de\ redondeo\ *) \)}], \
"Input"],

Cell["Obtengamos ahora la respuesta sin suponer periodicidad.", "Text"],

Cell[BoxData[{
    \(\(nuevasignal = 
        Join[signal, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevafunpulso = 
        Join[funpulso, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevarespuesta = 
          Chop[\(\@1023\) 
              InverseFourier[
                Fourier[nuevasignal]*Fourier[nuevafunpulso]]];\) // 
      Timing\)}], "Input"],

Cell["Comparemos los resultados obtenidos.", "Text"],

Cell[BoxData[
    \(\(\(g1 = ListPlot[respuesta];\)\( (*\ 
      observa\ c\[OAcute]mo\ la\ convoluci\[OAcute]n\ suaviza\ la\ \
se\[NTilde]al\ de\ entrada\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[nuevarespuesta];\)\)], "Input"],

Cell["\<\
Como puedes ver son muy diferentes. Para comparar mejor tomemos los primeros \
512 elementos de \"nuevarespuesta\".\
\>", "Text"],

Cell[BoxData[
    \(\(g2 = ListPlot[Take[nuevarespuesta, 512]];\)\)], "Input"],

Cell["Superpongamos las gr\[AAcute]ficas.", "Text"],

Cell[BoxData[
    \(\(Show[g1, g2];\)\)], "Input"],

Cell["\<\
Bueno, no son \"demasiado\" diferentes y las diferencias mayores se producen \
al principio. \
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.51.1"->{
    Cell[50672, 1453, 63, 1, 71, "Input",
      CellTags->"S5.51.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.51.1", 87842, 2451}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 49, 0, 99, "Title"],
Cell[1806, 53, 154, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[1985, 62, 88, 1, 93, "Section"],
Cell[2076, 65, 1015, 31, 67, "Text"],
Cell[3094, 98, 525, 13, 87, "Text"],
Cell[3622, 113, 1772, 56, 94, "Text"],
Cell[5397, 171, 82, 1, 41, "Text"],
Cell[5482, 174, 530, 14, 87, "Text"],
Cell[6015, 190, 1076, 33, 94, "Text"],
Cell[7094, 225, 546, 16, 67, "Text"],
Cell[7643, 243, 976, 24, 40, "Text"],
Cell[8622, 269, 782, 21, 67, "Text"],
Cell[9407, 292, 2031, 63, 236, "Text"],
Cell[11441, 357, 819, 18, 81, "Text"],
Cell[12263, 377, 458, 10, 78, "Text"],
Cell[12724, 389, 254, 8, 41, "Text"],
Cell[12981, 399, 633, 12, 91, "Text"],
Cell[13617, 413, 246, 7, 41, "Text"],
Cell[13866, 422, 2163, 66, 145, "Text"],
Cell[16032, 490, 311, 9, 41, "Text"],
Cell[16346, 501, 953, 20, 108, "Text"],
Cell[17302, 523, 620, 21, 67, "Text"],
Cell[17925, 546, 720, 18, 88, "Text"],
Cell[18648, 566, 538, 18, 67, "Text"],
Cell[19189, 586, 808, 29, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20034, 620, 60, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[20119, 624, 31, 0, 68, "Exercise"],
Cell[20153, 626, 4256, 86, 1009, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24458, 718, 51, 0, 93, "Section"],
Cell[24512, 720, 1442, 40, 162, "Text"],

Cell[CellGroupData[{
Cell[25979, 764, 31, 0, 68, "Exercise"],
Cell[26013, 766, 1581, 43, 209, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27643, 815, 94, 4, 93, "Section"],
Cell[27740, 821, 310, 8, 67, "Text"],
Cell[28053, 831, 390, 8, 77, "Text"],
Cell[28446, 841, 385, 12, 67, "Text"],
Cell[28834, 855, 395, 8, 77, "Text"],
Cell[29232, 865, 480, 13, 93, "Text"],
Cell[29715, 880, 376, 7, 202, "Input"],
Cell[30094, 889, 115, 3, 41, "Text"],
Cell[30212, 894, 466, 10, 202, "Input"],
Cell[30681, 906, 380, 8, 93, "Text"],
Cell[31064, 916, 299, 7, 150, "Input"],
Cell[31366, 925, 59, 0, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31462, 930, 91, 1, 93, "Section"],
Cell[31556, 933, 2261, 67, 260, "Text"],
Cell[33820, 1002, 140, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[33985, 1011, 31, 0, 68, "Exercise"],
Cell[34019, 1013, 1318, 33, 195, "ExerciseText"],
Cell[35340, 1048, 439, 12, 93, "ExerciseText"],
Cell[35782, 1062, 76, 1, 72, "Input"],
Cell[35861, 1065, 196, 5, 41, "Text"],
Cell[36060, 1072, 153, 3, 40, "Text"],
Cell[36216, 1077, 428, 12, 66, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36681, 1094, 31, 0, 68, "Exercise"],
Cell[36715, 1096, 1694, 31, 427, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38458, 1133, 130, 5, 93, "Section"],
Cell[38591, 1140, 456, 11, 93, "Text"],
Cell[39050, 1153, 44, 0, 71, "Definition"],
Cell[39097, 1155, 970, 14, 197, "Text"],
Cell[40070, 1171, 379, 6, 176, "Input"],
Cell[40452, 1179, 299, 4, 124, "Input"],
Cell[40754, 1185, 150, 3, 41, "Text"],
Cell[40907, 1190, 457, 8, 206, "Input"],
Cell[41367, 1200, 92, 1, 72, "Input"],
Cell[41462, 1203, 40, 0, 71, "Definition"],
Cell[41505, 1205, 824, 12, 171, "Text"],
Cell[42332, 1219, 71, 1, 72, "Input"],
Cell[42406, 1222, 189, 4, 98, "Input"],
Cell[42598, 1228, 299, 4, 150, "Input"],
Cell[42900, 1234, 264, 4, 124, "Input"],
Cell[43167, 1240, 152, 3, 41, "Text"],
Cell[43322, 1245, 415, 8, 176, "Input"],
Cell[43740, 1255, 198, 3, 98, "Input"],
Cell[43941, 1260, 128, 3, 41, "Text"],
Cell[44072, 1265, 105, 2, 72, "Input"],
Cell[44180, 1269, 96, 2, 71, "Definition"],
Cell[44279, 1273, 356, 6, 93, "Text"],
Cell[44638, 1281, 79, 1, 72, "Input"],
Cell[44720, 1284, 604, 9, 145, "Text"],
Cell[45327, 1295, 359, 6, 93, "Text"],
Cell[45689, 1303, 86, 1, 72, "Input"],
Cell[45778, 1306, 496, 9, 93, "Text"],
Cell[46277, 1317, 116, 3, 41, "Text"],
Cell[46396, 1322, 369, 7, 176, "Input"],
Cell[46768, 1331, 133, 3, 72, "Input"],
Cell[46904, 1336, 132, 2, 98, "Input"],
Cell[47039, 1340, 65, 0, 41, "Text"],
Cell[47107, 1342, 303, 6, 150, "Input"],
Cell[47413, 1350, 172, 3, 98, "Input"],
Cell[47588, 1355, 60, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47685, 1361, 50, 0, 93, "Section"],
Cell[47738, 1363, 446, 9, 93, "Text"],
Cell[48187, 1374, 158, 3, 124, "Input"],
Cell[48348, 1379, 260, 6, 124, "Input"],
Cell[48611, 1387, 139, 3, 72, "Input"],
Cell[48753, 1392, 250, 6, 67, "Text"],
Cell[49006, 1400, 131, 2, 72, "Input"],
Cell[49140, 1404, 163, 3, 67, "Text"],
Cell[49306, 1409, 58, 1, 72, "Input"],
Cell[49367, 1412, 82, 1, 41, "Text"],
Cell[49452, 1415, 88, 1, 72, "Input"],
Cell[49543, 1418, 213, 4, 67, "Text"],
Cell[49759, 1424, 65, 1, 72, "Input"],
Cell[49827, 1427, 60, 0, 41, "Text"],
Cell[49890, 1429, 49, 1, 72, "Input"],
Cell[49942, 1432, 92, 1, 41, "Text"],
Cell[50037, 1435, 74, 1, 72, "Input"],
Cell[50114, 1438, 71, 0, 41, "Text"],
Cell[50188, 1440, 67, 1, 72, "Input"],
Cell[50258, 1443, 411, 8, 93, "Text"],
Cell[50672, 1453, 63, 1, 71, "Input",
  CellTags->"S5.51.1"],
Cell[50738, 1456, 458, 9, 93, "Text"],
Cell[51199, 1467, 198, 5, 98, "Input"],
Cell[51400, 1474, 201, 6, 41, "Text"],
Cell[51604, 1482, 50, 1, 72, "Input"],
Cell[51657, 1485, 52, 1, 72, "Input"],
Cell[51712, 1488, 82, 1, 72, "Input"],
Cell[51797, 1491, 72, 1, 72, "Input"],
Cell[51872, 1494, 385, 8, 93, "Text"],
Cell[52260, 1504, 296, 7, 128, "Input"],
Cell[52559, 1513, 520, 13, 180, "Input"],

Cell[CellGroupData[{
Cell[53104, 1530, 79, 0, 68, "Exercise"],
Cell[53186, 1532, 1669, 36, 425, "Text"],
Cell[54858, 1570, 272, 6, 98, "Input"],
Cell[55133, 1578, 1268, 25, 223, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56450, 1609, 56, 0, 93, "Section"],
Cell[56509, 1611, 917, 29, 93, "Text"],
Cell[57429, 1642, 808, 23, 75, "Text"],
Cell[58240, 1667, 461, 15, 41, "Text"],
Cell[58704, 1684, 347, 10, 73, "Text"],
Cell[59054, 1696, 1586, 45, 145, "Text"],
Cell[60643, 1743, 191, 4, 77, "Text"],
Cell[60837, 1749, 1998, 53, 200, "Text"],
Cell[62838, 1804, 3412, 96, 329, "Text"],

Cell[CellGroupData[{
Cell[66275, 1904, 31, 0, 68, "Exercise"],
Cell[66309, 1906, 6188, 110, 1399, "ExerciseText"],
Cell[72500, 2018, 75, 0, 41, "Text"],
Cell[72578, 2020, 250, 5, 124, "Input"],
Cell[72831, 2027, 420, 7, 93, "Text"],
Cell[73254, 2036, 217, 4, 67, "Text"],
Cell[73474, 2042, 525, 10, 254, "Input"],
Cell[74002, 2054, 684, 10, 145, "Text"],
Cell[74689, 2066, 223, 4, 67, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74961, 2076, 85, 1, 93, "Section"],
Cell[75049, 2079, 213, 4, 67, "Text"],
Cell[75265, 2085, 191, 4, 77, "Text"],
Cell[75459, 2091, 1552, 50, 119, "Text"],
Cell[77014, 2143, 298, 6, 80, "Text"],
Cell[77315, 2151, 351, 14, 41, "Text"],
Cell[77669, 2167, 312, 5, 36, "Text"],
Cell[77984, 2174, 634, 18, 93, "Text"],
Cell[78621, 2194, 567, 9, 150, "Input"],
Cell[79191, 2205, 515, 14, 67, "Text"],
Cell[79709, 2221, 161, 2, 99, "Input"],
Cell[79873, 2225, 710, 18, 93, "Text"],
Cell[80586, 2245, 147, 2, 98, "Input"],
Cell[80736, 2249, 130, 3, 41, "Text"],
Cell[80869, 2254, 146, 2, 98, "Input"],
Cell[81018, 2258, 245, 4, 131, "Input"],
Cell[81266, 2264, 1742, 49, 172, "Text"],
Cell[83011, 2315, 870, 15, 150, "Text"],
Cell[83884, 2332, 124, 3, 41, "Text"],
Cell[84011, 2337, 105, 1, 71, "Definition"],
Cell[84119, 2340, 177, 6, 42, "Text"],
Cell[84299, 2348, 204, 4, 124, "Input"],
Cell[84506, 2354, 84, 1, 41, "Text"],
Cell[84593, 2357, 351, 7, 124, "Input"],
Cell[84947, 2366, 410, 7, 93, "Text"],
Cell[85360, 2375, 270, 6, 150, "Input"],
Cell[85633, 2383, 340, 7, 150, "Input"],
Cell[85976, 2392, 71, 0, 41, "Text"],
Cell[86050, 2394, 379, 9, 214, "Input"],
Cell[86432, 2405, 52, 0, 41, "Text"],
Cell[86487, 2407, 176, 3, 98, "Input"],
Cell[86666, 2412, 62, 1, 72, "Input"],
Cell[86731, 2415, 139, 3, 41, "Text"],
Cell[86873, 2420, 78, 1, 72, "Input"],
Cell[86954, 2423, 51, 0, 41, "Text"],
Cell[87008, 2425, 50, 1, 72, "Input"],
Cell[87061, 2428, 117, 3, 41, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

